### Summary ####
# Inputs: df_all_cu and df_f
# outputs: Figure C.1 and Figure C.2 in the appendix to justify scaling
# Outline 
# 1. Figure C.1 (a)
# 2. Figure C.1 (c)
# 3. Figure C.1 (b)
# 4. Figure C.1 (d)
# 5. Figure C.2 (a)
# 6. Figure C.2 (c)
# 7. Figure C.2 (b)
# 8. Figure C.2 (d)

### Preparations ####
setwd(getwd())

## Opening libraries 
library(readr) # For importing datasets 
library(dplyr) # for data processing 
library(ggplot2) # for plotting
library(weights) # for weighted mean

#### ********* All households ********* ####

### Data processing ####
df_all_cu <- read.csv("df_all_cu.csv")

# Find quantiles 
quantile(df_all_cu$FINCBTXM_FST,probs = c(1/3,2/3))

summary(df_all_cu$FINCBTXM_FST)

df_all_cu <- df_all_cu %>% select(NEWID,YYMM,FINLWT21_AVG, FINCBTXM_FST,
                                         EX_FD_t,EX_SN_t,EX_N_t,EX_T_t,
                                         EX_FD_tm1,EX_SN_tm1,EX_N_tm1,EX_T_tm1,
                                         EX_FD_AVG,EX_SN_AVG,EX_N_AVG,EX_T_AVG)

# Compute level difference 
df_all_cu$d_EX_FD <- df_all_cu$EX_FD_t - df_all_cu$EX_FD_tm1
df_all_cu$d_EX_SN <- df_all_cu$EX_SN_t - df_all_cu$EX_SN_tm1
df_all_cu$d_EX_N <- df_all_cu$EX_N_t - df_all_cu$EX_N_tm1
df_all_cu$d_EX_T <- df_all_cu$EX_T_t - df_all_cu$EX_T_tm1

# compute log difference 
df_all_cu$pd_EX_FD <- log(df_all_cu$EX_FD_t) - log(df_all_cu$EX_FD_tm1)
df_all_cu$pd_EX_SN <- log(df_all_cu$EX_SN_t) - log(df_all_cu$EX_SN_tm1)
df_all_cu$pd_EX_N <- log(df_all_cu$EX_N_t) - log(df_all_cu$EX_N_tm1)
df_all_cu$pd_EX_T <- log(df_all_cu$EX_T_t) - log(df_all_cu$EX_T_tm1)

df_all_cu$pd_EX_FD[is.infinite(df_all_cu$pd_EX_FD)] <- NA
df_all_cu$pd_EX_SN[is.infinite(df_all_cu$pd_EX_SN)] <- NA
df_all_cu$pd_EX_N[is.infinite(df_all_cu$pd_EX_N)] <- NA
df_all_cu$pd_EX_T[is.infinite(df_all_cu$pd_EX_T)] <- NA

# compute scaled difference 
df_all_cu$s_pd_EX_FD <- (df_all_cu$EX_FD_t - df_all_cu$EX_FD_tm1)/df_all_cu$EX_FD_AVG
df_all_cu$s_pd_EX_SN <- (df_all_cu$EX_SN_t - df_all_cu$EX_SN_tm1)/df_all_cu$EX_SN_AVG
df_all_cu$s_pd_EX_N <- (df_all_cu$EX_N_t - df_all_cu$EX_N_tm1)/df_all_cu$EX_N_AVG
df_all_cu$s_pd_EX_T <- (df_all_cu$EX_T_t - df_all_cu$EX_T_tm1)/df_all_cu$EX_T_AVG

df_all_cu$s_pd_EX_FD[is.infinite(df_all_cu$s_pd_EX_FD)] <- NA
df_all_cu$s_pd_EX_SN[is.infinite(df_all_cu$s_pd_EX_SN)] <- NA
df_all_cu$s_pd_EX_N[is.infinite(df_all_cu$s_pd_EX_N)] <- NA
df_all_cu$s_pd_EX_T[is.infinite(df_all_cu$s_pd_EX_T)] <- NA

# divide into income groups
df_all_cu$income_lv <- ifelse(df_all_cu$FINCBTXM_FST<42165.6,1,
                              ifelse(df_all_cu$FINCBTXM_FST>=42165.6 & df_all_cu$FINCBTXM_FST<=95817,2, 3))

df_all_cu$income_lv <- factor(df_all_cu$income_lv,
                              levels = c(1,2,3),
                              labels = c("low", "middle", "high"))

df_all_cu$YYMM <- as.factor(df_all_cu$YYMM)

df_all_cu$income_lv <- factor(df_all_cu$income_lv, levels = c('low', 'middle', 'high'))

# Compute average change by group and by interview month
df_all_cu_avg <- df_all_cu %>%
  group_by(income_lv,YYMM) %>%
  mutate(d_fd_avg = weighted.mean(d_EX_FD),
         
         d_sn_avg = weighted.mean(d_EX_SN),
         
         d_n_avg = weighted.mean(d_EX_N),
         
         d_t_avg = weighted.mean(d_EX_T),
         
         pd_fd_avg = weighted.mean(pd_EX_FD,na.rm=TRUE),
         
         pd_sn_avg = weighted.mean(pd_EX_SN, na.rm=TRUE),
         
         pd_n_avg = weighted.mean(pd_EX_N, na.rm=TRUE),
         
         pd_t_avg = weighted.mean(pd_EX_T, na.rm=TRUE),
         
         s_pd_fd_avg = weighted.mean(s_pd_EX_FD,na.rm=TRUE),
         
         s_pd_sn_avg = weighted.mean(s_pd_EX_SN, na.rm=TRUE),
         
         s_pd_n_avg = weighted.mean(s_pd_EX_N, na.rm=TRUE),
         
         s_pd_t_avg = weighted.mean(s_pd_EX_T, na.rm=TRUE),
  )

# drop repetitions 
df_all_cu_avg <- df_all_cu_avg %>% distinct(income_lv,YYMM,.keep_all = TRUE)

df_all_cu <- df_all_cu_avg

# d_fd <- ggplot(df_all_cu, aes(fill=income_lv, y=d_fd_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(x="Interview Month", y="Average level difference in food expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18)) + 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# d_fd

### Figure C.1 (a) ####
d_sn <- ggplot(df_all_cu, aes(fill=income_lv, y=d_sn_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in strictly nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18)) + 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

d_sn
ggsave("Figure C.1(a).pdf",width=8,height=8)
#ggsave("sn_le.png",width=8,height=8)

### Figure C.1 (c) ####
d_n <- ggplot(df_all_cu, aes(fill=income_lv, y=d_n_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18)) + 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

d_n
ggsave("Figure C.1(c).pdf",width=8,height=8)
#ggsave("n_le.png",width=8,height=8)

# d_t <- ggplot(df_all_cu, aes(fill=income_lv, y=d_t_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average level difference in total expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank()) +
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18)) + 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# d_t


# pd_fd <- ggplot(df_all_cu, aes(fill=income_lv, y=pd_fd_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in food expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18)) + 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_fd

### Figure C.1 (b) ####
pd_sn <- ggplot(df_all_cu, aes(fill=income_lv, y=pd_sn_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average log difference in strictly nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18))+ 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

pd_sn
ggsave("Figure C.1(b).pdf",width=8,height=8)
# ggsave("sn_log.png",width=8,height=8)

### Figure C.1 (d) ####
pd_n <- ggplot(df_all_cu, aes(fill=income_lv, y=pd_n_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average log difference in nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18)) + 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

pd_n
ggsave("Figure C.1(d).pdf",width=8,height=8)
#ggsave("n_log.png",width=8,height=8)


# pd_t <- ggplot(df_all_cu, aes(fill=income_lv, y=pd_t_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in total expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18)) + 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_t

#### ********* Final Sample ********* ####

### Data processing ####
# Import the data set
df_f <- read.csv("df_f.csv")

df_f <- df_f %>% select(NEWID,YYMM,FINLWT21_AVG, FINCBTXM_FST,
                        EX_FD_t,EX_SN_t,EX_N_t,EX_T_t,
                        EX_FD_tm1,EX_SN_tm1,EX_N_tm1,EX_T_tm1,
                        EX_FD_AVG,EX_SN_AVG,EX_N_AVG,EX_T_AVG)

# Compute level difference 
df_f$d_EX_FD <- df_f$EX_FD_t - df_f$EX_FD_tm1
df_f$d_EX_SN <- df_f$EX_SN_t - df_f$EX_SN_tm1
df_f$d_EX_N <- df_f$EX_N_t - df_f$EX_N_tm1
df_f$d_EX_T <- df_f$EX_T_t - df_f$EX_T_tm1

# compute log difference 
df_f$pd_EX_FD <- log(df_f$EX_FD_t) - log(df_f$EX_FD_tm1)
df_f$pd_EX_SN <- log(df_f$EX_SN_t) - log(df_f$EX_SN_tm1)
df_f$pd_EX_N <- log(df_f$EX_N_t) - log(df_f$EX_N_tm1)
df_f$pd_EX_T <- log(df_f$EX_T_t) - log(df_f$EX_T_tm1)

df_f$pd_EX_FD[is.infinite(df_f$pd_EX_FD)] <- NA
df_f$pd_EX_SN[is.infinite(df_f$pd_EX_SN)] <- NA
df_f$pd_EX_N[is.infinite(df_f$pd_EX_N)] <- NA
df_f$pd_EX_T[is.infinite(df_f$pd_EX_T)] <- NA

# compute scaled difference 
df_f$s_pd_EX_FD <- (df_f$EX_FD_t - df_f$EX_FD_tm1)/df_f$EX_FD_AVG
df_f$s_pd_EX_SN <- (df_f$EX_SN_t - df_f$EX_SN_tm1)/df_f$EX_SN_AVG
df_f$s_pd_EX_N <- (df_f$EX_N_t - df_f$EX_N_tm1)/df_f$EX_N_AVG
df_f$s_pd_EX_T <- (df_f$EX_T_t - df_f$EX_T_tm1)/df_f$EX_T_AVG

df_f$s_pd_EX_FD[is.infinite(df_f$s_pd_EX_FD)] <- NA
df_f$s_pd_EX_SN[is.infinite(df_f$s_pd_EX_SN)] <- NA
df_f$s_pd_EX_N[is.infinite(df_f$s_pd_EX_N)] <- NA
df_f$s_pd_EX_T[is.infinite(df_f$s_pd_EX_T)] <- NA

# divide into income groups
df_f$income_lv <- ifelse(df_f$FINCBTXM_FST<38808.2,1,
                         ifelse(df_f$FINCBTXM_FST>=38808.2 & df_f$FINCBTXM_FST<=85000,2, 3))

df_f$income_lv <- factor(df_f$income_lv,
                         levels = c(1,2,3),
                         labels = c("low", "middle", "high"))

df_f$YYMM <- as.factor(df_f$YYMM)

df_f$income_lv <- factor(df_f$income_lv, levels = c('low', 'middle', 'high'))

# Compute average change by group and by interview month
df_f_avg <- df_f %>%
  group_by(income_lv,YYMM) %>%
  mutate(d_fd_avg = weighted.mean(d_EX_FD, FINLWT21_AVG),
         
         d_sn_avg = weighted.mean(d_EX_SN, FINLWT21_AVG),
         
         d_n_avg = weighted.mean(d_EX_N, FINLWT21_AVG),
         
         d_t_avg = weighted.mean(d_EX_T, FINLWT21_AVG),
         
         pd_fd_avg = weighted.mean(pd_EX_FD, FINLWT21_AVG,na.rm=TRUE),
         
         pd_sn_avg = weighted.mean(pd_EX_SN, FINLWT21_AVG,na.rm=TRUE),
         
         pd_n_avg = weighted.mean(pd_EX_N, FINLWT21_AVG,na.rm=TRUE),
         
         pd_t_avg = weighted.mean(pd_EX_T, FINLWT21_AVG,na.rm=TRUE),
         
         s_pd_fd_avg = weighted.mean(s_pd_EX_FD, FINLWT21_AVG,na.rm=TRUE),
         
         s_pd_sn_avg = weighted.mean(s_pd_EX_SN, FINLWT21_AVG,na.rm=TRUE),
         
         s_pd_n_avg = weighted.mean(s_pd_EX_N, FINLWT21_AVG,na.rm=TRUE),
         
         s_pd_t_avg = weighted.mean(s_pd_EX_T, FINLWT21_AVG,na.rm=TRUE),
  )

# drop repetitions 
df_f_avg <- df_f_avg %>% distinct(income_lv,YYMM,.keep_all = TRUE)

df_f <- df_f_avg

# d_fd <- ggplot(df_f, aes(fill=income_lv, y=d_fd_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(x="Interview Month", y="Average level difference in food expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18)) + 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# 
# d_fd
# ggsave("f_fd_le.png",width=8,height=8)

### Figure C.2 (a) ####
d_sn <- ggplot(df_f, aes(fill=income_lv, y=d_sn_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in strictly nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18))+ 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

d_sn
ggsave("Figure C.2(a).pdf",width=8,height=8)
#ggsave("f_sn_le.png",width=8,height=8)

### Figure C.2 (c) ####
d_n <- ggplot(df_f, aes(fill=income_lv, y=d_n_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18))+ 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

d_n
ggsave("Figure C.2(c).pdf",width=8,height=8)
#ggsave("f_n_le.png",width=8,height=8)

# d_t <- ggplot(df_f, aes(fill=income_lv, y=d_t_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average level difference in total expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank()) +
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# d_t
# ggsave("f_t_le.png",width=8,height=8)


# pd_fd <- ggplot(df_f, aes(fill=income_lv, y=pd_fd_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in food expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_fd
# ggsave("f_fd_log.png",width=8,height=8)
# 
# pd_sn <- ggplot(df_f, aes(fill=income_lv, y=pd_sn_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in strictly nondurables expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_sn
# ggsave("f_sn_log.png",width=8,height=8)
# 
# 
# pd_n <- ggplot(df_f, aes(fill=income_lv, y=pd_n_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in nondurables expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_n
# ggsave("f_n_log.png",width=8,height=8)
# 
# 
# pd_t <- ggplot(df_f, aes(fill=income_lv, y=pd_t_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average log difference in total expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# pd_t
# ggsave("f_t_log.png",width=8,height=8)

# s_pd_fd <- ggplot(df_f, aes(fill=income_lv, y=s_pd_fd_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average level difference in scaled food expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# s_pd_fd
# ggsave("f_fd_Scaled.png",width=8,height=8)

### Figure C.2 (b) ####
s_pd_sn <- ggplot(df_f, aes(fill=income_lv, y=s_pd_sn_avg, x=YYMM)) +
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in scaled strictly nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"),
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18))+ 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

s_pd_sn
ggsave("Figure C.2(b).pdf",width=8,height=8)
#ggsave("f_sn_Scaled.png",width=8,height=8)

### Figure C.2 (d) ####
s_pd_n <- ggplot(df_f, aes(fill=income_lv, y=s_pd_n_avg, x=YYMM)) + 
  geom_bar(position="dodge", stat="identity") +
  labs(colour = "Income Level",x="Interview Month", y="Average level difference in scaled nondurables expenditures") +
  guides(fill=guide_legend(title="Income Level"))+
  theme_classic()+
  theme(axis.line = element_line(colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        panel.background = element_blank())+
  scale_fill_manual(values=c("gray44","steelblue2","wheat"))+
  theme(legend.position = "bottom",
        legend.spacing.y = unit(0, "mm"), 
        aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
        legend.background = element_blank(),
        legend.key.size = unit(0.7, "cm"),
        legend.box.background = element_rect(colour = "black"))+
  theme(text = element_text(family="serif"),
        axis.text.x = element_text(size = 18),
        axis.text.y = element_text(size = 18),
        axis.title = element_text(size = 18),
        legend.text = element_text(size = 18),
        legend.title = element_text(size = 18))+ 
  scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
                   labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))

s_pd_n
ggsave("Figure C.2(d).pdf",width=8,height=8)
#ggsave("f_n_Scaled.png",width=8,height=8)

# s_pd_t <- ggplot(df_f, aes(fill=income_lv, y=s_pd_t_avg, x=YYMM)) + 
#   geom_bar(position="dodge", stat="identity") +
#   labs(colour = "Income Level",x="Interview Month", y="Average level difference in scaled total expenditures") +
#   guides(fill=guide_legend(title="Income Level"))+
#   theme_classic()+
#   theme(axis.line = element_line(colour = "black"),
#         panel.grid.major = element_blank(),
#         panel.grid.minor = element_blank(),
#         panel.border = element_blank(),
#         panel.background = element_blank())+
#   scale_fill_manual(values=c("gray44","steelblue3","wheat"))+
#   theme(legend.position = "bottom",
#         legend.spacing.y = unit(0, "mm"), 
#         aspect.ratio = 1, axis.text = element_text(colour = 1, size = 12),
#         legend.background = element_blank(),
#         legend.key.size = unit(0.7, "cm"),
#         legend.box.background = element_rect(colour = "black"))+
#   theme(text = element_text(family="serif"),
#         axis.text.x = element_text(size = 18),
#         axis.text.y = element_text(size = 18),
#         axis.title = element_text(size = 18),
#         legend.text = element_text(size = 18),
#         legend.title = element_text(size = 18))+ 
# scale_x_discrete(breaks=c("1912","2001","2003", "2004","2006","2007","2009","2010","2012", "2101"),
#                  labels=c("Dec19", "Jan", "Mar", "Apr", "Jun", "Jul", "Sep", "Oct", "Dec20", "Jan21"))
# 
# s_pd_t
# ggsave("f_t_Scaled.png",width=8,height=8)
